exports.validateMaximumOfTenItems = (req, res) => {
  var cart = req.body.resource.obj;
  var itemsTotal = cart.lineItems.reduce( (acc, curr) => { 
    return acc + curr.quantity;
  }, 0);

  if (itemsTotal <= 10) {
    res.status(200).end();
  }
  else {
    res.status(400).json({
      errors : [{
        code: "InvalidInput",
        message: "You can not put more than 10 items into the cart."
      }]
    });
  }
};
