module.exports = function (context, req) {
    // Reject a cart that orders more than 10 items
    var cart = req.body.resource.obj;
    var itemsTotal = cart.lineItems.reduce( (acc, curr) => { 
        return acc + curr.quantity;
    }, 0);

    if (itemsTotal <= 10) {
        context.res = {
            status: 200,
            body: undefined
        };
    }
    else {
        context.res = {
            status: 400,
            body : {
                errors : [{
                    code: "InvalidInput",
                    message: "You can not put more than 10 items into the cart."
                }]
            }
        };
    }
    
    context.done();
};